//
//  $Id: AHKMMainWindowController.h 94 2009-06-11 15:28:02Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//

#import <Cocoa/Cocoa.h>

extern NSString*	AHKMPhoneNumberDefaultsKey;
extern NSString*	AHKMFileFormatDefaultsKey;
// extern NSString*	AHKMDefaultsLastSentDateKey;
extern NSString*	AHKMDefaultsLastReceivedDateKey;


typedef enum {
	AHKMMboxFileFormat = 0,
	AHKMRFC822MessageFileFormat,
	AHKMVMessageFileFormat
} AHKMFileFormat;


@class AHKMail, AHKMArrayController;


@interface AHKMMainWindowController : NSWindowController
{
	//IBOutlet NSTextField	*phoneNumberTextField;
	//IBOutlet NSTextField	*emailAddressTextField;
	NSArray *_mails;
	
    IBOutlet AHKMArrayController *mailsController;
	IBOutlet NSView              *fileFormatView;
	IBOutlet NSPopUpButton       *fileFormatPopUpButton;
	IBOutlet NSTextField         *phoneNumberTextField;
	IBOutlet NSView              *mailboxView;
	IBOutlet NSTableColumn       *objectTableColumn;
}

#pragma mark accessor methods
- (NSArray *)mails;
- (void)setMails:(NSArray *)mails;

//#pragma mark accessor methods for to-many relationships
//- (unsigned int)countOfMails;
//- (AHKMail *)objectInMailsAtIndex:(unsigned int)index;
////- (void)insertObject:(AHKPerson *)person inPeopleAtIndex:(unsigned int)index;
////- (void)removeObjectFromPeopleAtIndex:(unsigned int)index;
////- (void)replaceObjectInPeopleAtIndex:(unsigned int)index withObject:(AHKPerson *)person;

#pragma mark action
- (IBAction)selectNext:(id)sender;
- (IBAction)selectPrevious:(id)sender;
//- (IBAction)newEmail:(id)sender;
//- (IBAction)newLightMail:(id)sender;
- (IBAction)guess:(id)sender;

- (IBAction)showSelectedMailboxMails:(id)sender;
- (IBAction)showAllMails:(id)sender;
- (IBAction)showInboxMails:(id)sender;
- (IBAction)showOutboxMails:(id)sender;
@end


@interface AHKMMainWindowController (IO)

- (IBAction)exportSelection:(id)sender;
- (IBAction)backupDatabase:(id)sender;
- (IBAction)revertFromDatabaseBackup:(id)sender;
- (IBAction)receiveMails:(id)sender;
//- (IBAction)sendMails:(id)sender;

- (void)confirmRevertDatabaseFromFile:(NSString *)filename;
- (BOOL)loadDefaultDatabase;
- (BOOL)storeDefaultDatabase;

@end


@interface AHKMMainWindowController (Toolbar)

- (void)setupToolbar;

@end
